/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component;

import com.fantasticsource.tools.component.CBoolean;
import com.fantasticsource.tools.component.CStringUTF8;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Component {
    public static <T extends Component> T writeMarked(ByteBuf buf, T component) {
        new CStringUTF8().set(component.getClass().getName()).write(buf);
        component.write(buf);
        return component;
    }

    public static <T extends Component> T writeMarkedOrNull(ByteBuf buf, T component) {
        if (component == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Component.writeMarked(buf, component);
        }
        return component;
    }

    public static Component readMarked(ByteBuf buf) {
        try {
            return ((Component)Class.forName(new CStringUTF8().read((ByteBuf)buf).value).newInstance()).read(buf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Component readMarkedOrNull(ByteBuf buf) {
        if (buf.readBoolean()) {
            return Component.readMarked(buf);
        }
        return null;
    }

    public static <T extends Component> T saveMarked(OutputStream stream, T component) {
        new CStringUTF8().set(component.getClass().getName()).save(stream);
        component.save(stream);
        return component;
    }

    public static <T extends Component> T saveMarkedOrNull(OutputStream stream, T component) {
        if (component == null) {
            new CBoolean().set(false).save(stream);
        } else {
            new CBoolean().set(true).save(stream);
            Component.saveMarked(stream, component);
        }
        return component;
    }

    public static Component loadMarked(InputStream stream) {
        try {
            return ((Component)Class.forName(new CStringUTF8().load((InputStream)stream).value).newInstance()).load(stream);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Component loadMarkedOrNull(InputStream stream) {
        if (new CBoolean().load((InputStream)stream).value) {
            return Component.loadMarked(stream);
        }
        return null;
    }

    public static <T extends Component> T writeTextMarked(BufferedWriter writer, T component) {
        try {
            writer.write(component.getClass().getName() + "\r\n");
            component.writeText(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return component;
    }

    public static Component readTextMarked(BufferedReader reader) {
        try {
            return ((Component)Class.forName(reader.readLine()).newInstance()).readText(reader);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract Component write(ByteBuf var1);

    public abstract Component read(ByteBuf var1);

    public abstract Component save(OutputStream var1);

    public abstract Component load(InputStream var1);

    public Component writeText(BufferedWriter writer) {
        return this;
    }

    public Component readText(BufferedReader reader) {
        return this;
    }

    public Component copy() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
        Component.saveMarked(os, this);
        return Component.loadMarked(new ByteArrayInputStream(os.toByteArray()));
    }

    public void onClientSync() {
    }
}

